<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Edit Link
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

        <?php if (isset($originalLinkExist)) {
    ?>
            <?php $short_link = $this->Html->url('/' . $originalLinkExist[ 'Link' ][ 'alias' ], true);
    ?>

            <div class="alert alert-info alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <h4><i class="fa fa-info-circle"></i> This link is already existing</h4>
                <pre><?php echo $short_link;
    ?></pre>
            </div>

        <?php 
} ?>


        <?php
        echo $this->Form->create('Link', array(
            'inputDefaults' => array(
                'label' => false,
                'div'   => false,
                'class' => 'form-control placeholder-no-fix',
                'error' => array(
                    'attributes' => array( 'wrap' => 'span', 'class' => 'help-block' )
                )
            )
        ));
        ?>
        <?php echo $this->Form->input('id', array( 'type' => 'hidden' )); ?>
        <div class="form-group <?php echo($this->Form->isFieldError('title') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkTitle">Title</label>
            <?php echo $this->Form->input('title'); ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('description') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkDescription">Description</label>
            <?php echo $this->Form->input('description'); ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('password') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkPassword">Password</label>
            <?php echo $this->Form->input('password', array('type' => 'text')); ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('redirection_type') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkRedirectionType">Redirection Type</label>
            <?php
                $redirections = array(
                    '0' => 'Default',
                    '1' => 'Direct',
                    '2' => 'Counter Page'
                );

                $redirect_options = array('0' => 'Default');
                foreach ($user_plan[ 'Plan' ][ 'redirections' ] as $redirect) {
                    $redirect_options[ $redirect ] = $redirections[ $redirect ];
                }

                echo $this->Form->input('redirection_type', array( 'options' => $redirections ));
            ?>
        </div>

        <div class="form-group <?php echo($this->Form->isFieldError('bundle_id') ? 'has-error' : ''); ?>">
            <label class="control-label" for="LinkBundleId">Bundle</label>
            <?php
            echo $this->Form->input('bundle_id', array(
                'options' => $bundles,
                'empty'   => 'Select Bundle'
            ));
            ?>
        </div>

        <?php echo $this->Form->end(array( 'label' => 'Submit', 'class' => 'btn btn-primary btn-lg pull-right' )); ?>


    </div>
</div>
<!-- END PAGE CONTENT-->